import { NextRequest, NextResponse } from 'next/server';
import fs from 'node:fs/promises';
import path from 'node:path';

export const runtime = 'nodejs';

const UPLOAD_DIR = path.join(process.cwd(), 'tmp', 'uploads');

export async function GET(_: NextRequest, { params }: { params: { id: string } }) {
  const fileName = params.id;
  const filePath = path.join(UPLOAD_DIR, fileName);
  try {
    const data = await fs.readFile(filePath);
    const ext = fileName.split('.').pop()?.toLowerCase();
    const mime = ext === 'png' ? 'image/png' : ext === 'webp' ? 'image/webp' : 'image/jpeg';
    return new NextResponse(data, { headers: { 'Content-Type': mime, 'Cache-Control': 'public, max-age=600' } });
  } catch {
    return new NextResponse('Not Found', { status: 404 });
  }
}
